import UIKit

@objc
public protocol GMSScreenSharingViewControllerDelegate {
    
    func updateScreenSharingState(state: Bool)
}

class GMSScreenSharingViewController: UIViewController, UITextFieldDelegate {
    
    var delegate: GMSScreenSharingViewControllerDelegate?
    
    var appDelegate: GMSAppDelegate
    
    @IBOutlet weak var enabledSwitch: UISwitch!
    @IBOutlet weak var serviceNameField: UITextField!
    @IBOutlet weak var accessCodeField: UITextField!
    @IBOutlet weak var errorTextView: UITextView!
    
    required init?(coder aDecoder: NSCoder) {
        appDelegate = UIApplication.sharedApplication().delegate as! GMSAppDelegate
        super.init(coder: aDecoder)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        if appDelegate.screenSharingServiceName != nil {
            serviceNameField.text = appDelegate.screenSharingServiceName
        }
        if appDelegate.screenSharing == nil {
            let view = appDelegate.window!.rootViewController!.view
            
            appDelegate.screenSharing = GMSScreenSharing()
        }
        
        updateUIState()
    }
    
    override func viewDidAppear(animated: Bool) {
        appDelegate.screenSharing.addObserver(self, forKeyPath: "isOn", options: NSKeyValueObservingOptions.New, context: nil)
        appDelegate.screenSharing.addObserver(self, forKeyPath: "accessCode", options: NSKeyValueObservingOptions.New, context: nil)
    }
    
    override func viewDidDisappear(animated: Bool) {
        appDelegate.screenSharing.removeObserver(self, forKeyPath: "isOn")
        appDelegate.screenSharing.removeObserver(self, forKeyPath: "accessCode")
    }
    
    override func observeValueForKeyPath(keyPath: String?, ofObject: AnyObject?, change: [String : AnyObject]?,
        context: UnsafeMutablePointer<Void>) {
        
        updateUIState()
    }
    
    // Called when Return is tapped when finished editing ServiceName TextField
    func textFieldShouldReturn(textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        appDelegate.screenSharingServiceName = textField.text
        updateUIState()
        return false
    }
    
    func updateUIState() {
        if let text = serviceNameField.text {
            enabledSwitch.enabled = !text.isEmpty
        }
        else {
            enabledSwitch.enabled = false
        }
        enabledSwitch.on = appDelegate.screenSharing.isOn
        serviceNameField.enabled = !enabledSwitch.on
        accessCodeField.text = appDelegate.screenSharing.accessCode
        
        let error = appDelegate.screenSharing.error
        if error != nil {
            errorTextView.text = appDelegate.screenSharing.error!.localizedDescription
            errorTextView.hidden = false
        }
        else {
            errorTextView.text = ""
            errorTextView.hidden = true
        }
    }
    
    @IBAction func switchValueChanged(sender: AnyObject) {
        
        if enabledSwitch.on {
            appDelegate.screenSharing!.startSharingWithServiceName(serviceNameField.text!,
                view: appDelegate.window!.rootViewController!.view)
        }
        else {
            appDelegate.screenSharing!.stopSharing()
        }
    }
}
